<div class="full__with__section">
	<div class="inner__page__content__container">
		<div class="row justify-content-start">
			<div class="col-md-8 col-12">
				<div class="orderform__cart__header mt-5">
					<h1 class="coodiv-text-5 font-weight-bold mb-0 text-capitalize">{$product->name}</h1>
					<p class="coodiv-text-10 font-weight-300">{$product->description}</p>
				</div>
			</div>
		</div>
	</div>
	
	
	<div class="full__with__section cart__categories__menu__wrapper full__width__secondarysidebar__menu mt-9 mb-10 into__main__page__content__full__width__element">
		<div class="full__width__secondarysidebar__menu__item main__page__content d-flex align-items-start">
			<div class="product__cart__sidepanel__group">
					<a href="#" class="product__cart__sidepanel__item active">
						<svg class="product__cart__sidepanel__item__icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14"><g id="module-puzzle-1--code-puzzle-module-programming-plugin-piece"><path id="Vector" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" d="M4.1 1.211c.36.351.573.824.599 1.325L6.521.723a.668.668 0 0 1 .996 0l1.475 1.535c-.21.101-.402.236-.568.398a2.052 2.052 0 0 0 2.899 2.9c.162-.167.297-.36.399-.569l1.554 1.535a.668.668 0 0 1 0 .996l-1.813 1.784a2.043 2.043 0 1 1-2.162 2.162l-1.824 1.813a.668.668 0 0 1-.996 0l-1.475-1.534c.21-.102.402-.237.568-.4a2.057 2.057 0 1 0-3.317-2.33L.723 7.478a.668.668 0 0 1 0-.996l1.813-1.784a1.993 1.993 0 0 1-1.325-.597 2.043 2.043 0 1 1 2.89-2.89v0Z"></path></g></svg>
						{$product->name}
					</a>
					<a href="{$WEB_ROOT}/cart.php" class="product__cart__sidepanel__item">
						<svg class="product__cart__sidepanel__item__icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14"><g id="database-server-2--server-network-internet"><path id="Vector" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" d="M12.5.5h-11a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h11a1 1 0 0 0 1-1v-3a1 1 0 0 0-1-1Z"></path><path id="Vector_2" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" d="M7.5 3H11"></path><path id="Vector_3" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" d="M1.5 5.5a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h11a1 1 0 0 0 1-1v-3a1 1 0 0 0-1-1"></path><g id="Group 623"><path id="Vector_4" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" d="M3.25 8.25a.25.25 0 0 1 0-.5"></path><path id="Vector_5" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" d="M3.25 8.25a.25.25 0 0 0 0-.5"></path></g><g id="Group 627"><path id="Vector_6" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" d="M3.25 3.25a.25.25 0 0 1 0-.5"></path><path id="Vector_7" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" d="M3.25 3.25a.25.25 0 0 0 0-.5"></path></g><path id="Vector_8" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" d="M7.5 8H11"></path><path id="Vector_9" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" d="M7 10.5v3"></path><path id="Vector_10" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" d="M2 13.5h10"></path></g></svg>
						{lang key='navservicesorder'}
					</a>
					<a href="{$WEB_ROOT}/domainchecker.php" class="product__cart__sidepanel__item">
						<svg class="product__cart__sidepanel__item__icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14"><g id="web--server-world-internet-earth-www-globe-worldwide-web-network"><path id="Vector" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" d="M7 13.5a6.5 6.5 0 1 0 0-13 6.5 6.5 0 0 0 0 13Z"></path><path id="Vector_2" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" d="M.5 7h13"></path><path id="Vector_3" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" d="M9.5 7A11.22 11.22 0 0 1 7 13.5 11.22 11.22 0 0 1 4.5 7 11.22 11.22 0 0 1 7 .5 11.22 11.22 0 0 1 9.5 7v0Z"></path></g></svg>
						{lang key='navregisterdomain'}
					</a>
			</div>
		</div>
	</div>


	<div class="inner__page__content__container mt-8">
		<div class="store-order-container mb-3">
			<form method="post" action="{routePath('cart-order-addtocart')}" id="frmAddToCart">
				<input type="hidden" name="pid" value="{$product->id}">
				<input type="hidden" name="domain_type" value="" id="inputDomainType">
				<h6 class="coodiv-text-8 font-weight-300 mb-3">{lang key='store.choosePaymentTerm'}</h6>
				<div class="shadow__card mb-10">
					<div class="card__body payment-term float-none">
						<select name="billingcycle" class="form-control custom-select">
							{foreach $product->pricing()->allAvailableCycles() as $pricing}
								<option value="{$pricing->cycle()}"{if $requestedCycle == $pricing->cycle()} selected{/if}>
									{if $pricing->isRecurring()}
										{if $pricing->isYearly()}
											{$pricing->cycleInYears()} - {$pricing->yearlyPrice()}
										{else}
											{$pricing->cycleInMonths()} - {$pricing->monthlyPrice()}
										{/if}
									{else}
										{$pricing->toFullString()}
									{/if}
								</option>
							{/foreach}
						</select>
					</div>
				</div>		
				
				<h6 class="coodiv-text-8 font-weight-300">{lang key='store.chooseDomain'}</h6>
				<div class="order-domain-select-wrapper mt-0">
					<div class="order-domain-select">
						<div class="order-domain-select-header">
							<ul class="nav store-domain-tabs" role="tablist">
								{if $requireDomain}
								{if (count($domains) > 0 && $loggedin)}
								<li class="nav-item active" role="presentation">
									<a class="nav-link" href="#existing-domain" aria-controls="existing-domain" role="tab" data-toggle="tab">
										{lang key='store.chooseExistingDomain'}
									</a>
								</li>
								{/if}
								{if $allowSubdomains}
								<li class="nav-item" role="presentation">
									<a class="nav-link" href="#sub-domain" aria-controls="sub-domain" role="tab" data-toggle="tab">
										{lang key='store.subOfExisting'}
									</a>
								</li>
								{/if}
								<li class="nav-item" role="presentation">
									<a class="nav-link" id="tabCustomDomainControl" href="#custom-domain" aria-controls="custom-domain" role="tab" data-toggle="tab">
										{lang key='store.domainAlreadyOwned'}
									</a>
								</li>
								{else}
								<li class="nav-item" role="presentation">
									<a class="nav-link" id="tabNoDomain" href="#no-domain" role="tab" data-toggle="tab">
										{lang key='store.noDomain'}
									</a>
								</li>
								{/if}
							</ul>
						</div>
						<div class="order-domain-select-body">
							<div class="tab-content bg-white border-0 store-domain-tab-content">
								{if $requireDomain}
									{if count($domains) > 0}
										<div role="tabpanel" class="tab-pane active" id="existing-domain">
											{if $loggedin}
												<div class="store-domain-form">
													<select class="form-control custom-select" name="existing_domain">
														{foreach $domains as $domain}
															<option value="{$domain}"{if $domain == $selectedDomain} selected="selected"{/if}>
																{$domain}
															</option>
														{/foreach}
													</select>
													<span class="domain-validation ok">
														<i class="fas fa-check"></i>
														{lang key='store.eligible'}
													</span>
												</div>
											{else}
												<a href="{routePath('cart-order-login')}">{lang key='store.login'}</a> {lang key='store.addToExistingPackage'}
											{/if}
										</div>
									{/if}
									{if $allowSubdomains}
										<div role="tabpanel" class="tab-pane" id="sub-domain">
											<div class="store-domain-form">
												<div class="input-group">
													<input type="text" class="form-control subdomain-input" name="sub_domain" placeholder="Your desired subdomain">
													<select class="custom-select" name="existing_sld_for_subdomain" id="existing_sld_for_subdomain">
														{foreach $domains as $domain}
															<option value="{$domain}">.{$domain}</option>
														{/foreach}
													</select>
												</div>
												<span class="domain-validation subdomain-validation"></span>
											</div>
										</div>
									{/if}
									<div role="tabpanel" class="tab-pane" id="custom-domain">
										<div class="store-domain-form">
										<input type="text" class="form-control domain-input" placeholder="example.com" name="custom_domain" value="{$customDomain}">
										<span class="domain-validation domain-input-validation"></span>
										</div>
									</div>
								{else}
									<div role="tabpanel" class="tab-pane" id="no-domain">
										{lang key='store.noDomainRequired'}
									</div>
								{/if}
							</div>
						</div>
						<div class="card__footer">
							<div class="row">
								<div class="col-sm-5 col-12 d-flex align-items-center justify-content-start">
									 <a href="javascript:history.go(-1)" class="btn btn-default btn-sm">
										{lang key='back'}
									</a>
								</div>
								<div class="col-sm-7 col-12 d-flex align-items-center justify-content-end gap-10">
									<button type="submit" name="continue" value="1" class="btn btn-default btn-sm">
										{lang key='orderForm.continueShopping'}
									</button>
									<button type="submit" name="checkout" value="1" class="btn btn-primary btn-sm">
										{lang key='orderForm.checkout'}
									</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</form>
		</div>
	</div>
	{if $upsellProduct && $promotion}
		<div class="inner__page__content__container">
			<div class="minimalist__promo__banner shadow__card my-8">
				<div class="banner-background">
				<div class="banner-shape">
					{include file="$template/assets/svg/core/banner-shape-illustration.tpl"} 	
				</div>
				</div>
				<div class="minimalist__promo__banner__body">
					<div class="minimalist__promo__banner__content">
						<div class="minimalist__promo__banner__content__header mb-5">
							<h6 class="coodiv-text-7 font-weight-700 minimalist__promo__banner__title mb-0">{$promotion->getHeadline()}</h6>
							<p class="coodiv-text-11 font-weight-400 minimalist__promo__banner__desc">{$promotion->getTagline()}</p>
						</div>
						{if $promotion->getDescription()}
							<p class="minimalist__promo__banner__desc">{$promotion->getDescription()}</p>
						{/if}                    
						{if $promotion->hasFeatures()}
							<ul class="minimalist__promo__banner__desc__ul">
								{foreach $promotion->getFeatures() as $highlight}
									<li>{$highlight}</li>
								{/foreach}
							</ul>
						{/if}
						<div class="minimalist__promo__banner__actions">
						<form method="post" action="{routePath('cart-order')}">
							<input type="hidden" name="pid" value="{$upsellProduct->id}">
							<button type="submit" class="btn btn-primary-light btn-sm mt-5">
								{foreach $product->pricing()->allAvailableCycles() as $pricing}
									<span class="span-upsell span-upsell-{$pricing->cycle()}">
										{if is_null($upsellComparison->diff({$pricing->cycle()}))}
											{$promotion->getCta()} {$upsellProduct->name} {lang key='fromJust'} {$upsellProduct->pricing()->best()->breakdownPrice()}
										{else}
											{$promotion->getCta()} {$upsellProduct->name} {lang key='forJust'} {$upsellComparison->diff({$pricing->cycle()})->breakdownPrice()} {{lang key='more'}|lower}
										{/if}
									</span>
								{/foreach}
							</button>
						</form>
						</div>
					</div>
				</div>
				<div class="minimalist__promo__banner__illustration">
					{if file_exists("templates/$template/assets/svg/orderform/{$promotion->getServiceName()}-illustration.tpl")}
						{include file="$template/assets/svg/orderform/{$promotion->getServiceName()}-illustration.tpl"} 
					{/if}
				</div>
			</div>
		</div>
	{/if}
</div>

<script>
jQuery(document).ready(function(){

    var delay = (function(){
      var timer = 0;
      return function(callback, ms){
        clearTimeout (timer);
        timer = setTimeout(callback, ms);
      };
    })();

    jQuery('.store-order-container .subdomain-input').keyup(function() {
        delay(function(){
          jQuery('.subdomain-validation').html('<i class="fas fa-spinner fa-spin"></i> Validating...').removeClass('ok');

          jQuery('#frmAddToCart button[type="submit"]').prop('disabled', true);

          var domainName = jQuery('.subdomain-input').val() + '.' + jQuery('#existing_sld_for_subdomain').val();

          WHMCS.http.jqClient.post('{routePath('cart-order-validate')}', 'domain=' + domainName, function(data) {
              if (data.valid) {
                  jQuery('.subdomain-validation').html('<i class="fas fa-check"></i> Valid').addClass('ok');
                  jQuery('#frmAddToCart button[type="submit"]').removeProp('disabled');
              } else {
                  jQuery('.subdomain-validation').html('<i class="fas fa-times"></i> Invalid domain');
              }
          }, 'json');

        }, 1000 );
    });

    var delay2 = (function(){
      var timer = 0;
      return function(callback, ms){
        clearTimeout (timer);
        timer = setTimeout(callback, ms);
      };
    })();

    jQuery('.store-order-container .domain-input').keyup(function() {
        delay2(function(){
          jQuery('.domain-input-validation').html('<i class="fas fa-spinner fa-spin"></i> Validating...').removeClass('ok');
          jQuery('#frmAddToCart button[type="submit"]').prop('disabled', true);
          WHMCS.http.jqClient.post('{routePath('cart-order-validate')}', 'domain=' + jQuery('.domain-input').val(), function(data) {
            if (data.valid) {
                jQuery('.domain-input-validation').html('<i class="fas fa-check"></i> Valid').addClass('ok');
                jQuery('#frmAddToCart button[type="submit"]').removeProp('disabled');
            } else {
                jQuery('.domain-input-validation').html('<i class="fas fa-times"></i> Invalid domain');
            }
          }, 'json');
        }, 1000 );
    });
    {if $requireDomain}
        jQuery('.store-domain-tabs a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
            var tab = jQuery(e.target).attr('aria-controls');
            jQuery('#inputDomainType').val(tab);
            if (tab == 'custom-domain' || tab == 'sub-domain') {
                var validationBlockSelector = tab == 'custom-domain' ? '.domain-input-validation' : '.subdomain-validation';
                var validationHtml = jQuery(validationBlockSelector).html();

                if (validationHtml == '<i class="fas fa-check"></i> Valid') {
                    jQuery('#frmAddToCart button[type="submit"]').removeProp('disabled');
                } else {
                    jQuery('#frmAddToCart button[type="submit"]').prop('disabled', true);
                }
            } else {
                {if $loggedin}
                    jQuery('#frmAddToCart button[type="submit"]').removeProp('disabled');
                {else}
                    jQuery('#frmAddToCart button[type="submit"]').prop('disabled', true);
                {/if}
            }
        });
    {/if}

    jQuery('.store-domain-tabs li').removeClass('active');
    jQuery('.store-domain-tabs li:first-child a').click();
    {if !$loggedin && $requireDomain}
        jQuery('#frmAddToCart button[type="submit"]').prop('disabled', true);
    {/if}

    jQuery('.payment-term').find('select').change(function() {
        var cycle = jQuery('.payment-term').find('option:selected').val();
        updateUpsellDetailsOnBillingCycleChange(cycle);
    });
    updateUpsellDetailsOnBillingCycleChange(jQuery('.payment-term').find('option:selected').val());

    {if $customDomain}
        jQuery('#tabCustomDomainControl').click();
        jQuery('.store-order-container .domain-input').trigger('keyup');
    {/if}
});

function updateUpsellDetailsOnBillingCycleChange(cycle) {
    jQuery('.span-upsell').hide();
    jQuery('.span-upsell-' + cycle).show();
}
</script>
